package topdown.concrete_operator;

import topdown.data_structures.Tuple;
import topdown.operator.Relation;

import java.util.Iterator;

public class ConcreteRelation implements ConcreteOperator {

    private Iterator<Tuple> it;
    private final Relation relation;

    public ConcreteRelation(Relation relation) {
        this.relation = relation;
        it = relation.iterator();
    }

    @Override
    public Tuple next() {
        return it.hasNext() ? it.next() : null;
    }

    @Override
    public void reset() {
        it = relation.iterator();
    }

    @Override
    public ConcreteOperator instance() {
        return new ConcreteRelation(relation);
    }

}